//
//  RWAWSS3.h
//  S3Uploader
//
//  Created by Tom Bradley on 16/08/2019.
//  Copyright © 2019 Codebots. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

extern NSString *const AWSHostname;

@interface RWAWSS3 : NSObject

@property (nonatomic, strong) NSString *accessKey;
@property (nonatomic, strong) NSString *secret;
@property (nonatomic, strong) NSString *region;

+ (NSString *)bucketForPath:(NSString *)path;
+ (NSString *)keyForPath:(NSString *)path;

- (NSMutableURLRequest *)listBucketsRequest;
- (NSMutableURLRequest *)listRequestForPath:(NSString *)path;

- (NSMutableURLRequest *)regionRequestForPath:(NSString *)path;

- (NSMutableURLRequest *)generateGETRequestForPath:(NSString *)filePath;
- (NSMutableURLRequest *)generatePUTRequestForPath:(NSString *)filePath;
- (NSMutableURLRequest *)generateDELETERequestForPath:(NSString *)filePath;

@end

NS_ASSUME_NONNULL_END
